<?php

//exam.php

include('Soes.php');

$object = new Soes;
 
if (!isset($_SESSION['user_email'])) {
    header ('Location:../../login.php');
    exit;
}

$object->query = "
SELECT * FROM class_soes 
WHERE class_status = 'Enable' 
ORDER BY class_name ASC
";

$result = $object->get_result();

// include('header.php');
                
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">
  <title>CYBERSHIELD | TRAINING MANAGEMENT SYSTEM</title> 
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="../../assets/img/icon1.png" rel="icon">
  <link href="../../assets/img/icon1.png" rel="apple-touch-icon"> 
  <!-- DataTables -->
  <link rel="stylesheet" href="../../stp_con/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="../../stp_con/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="../../stp_con/datatables-buttons/css/buttons.bootstrap4.min.css"> 
  <link rel="stylesheet" href="../../assets/css/adminlte.min.css"> 
 <link rel="stylesheet" href="../../stp_con/summernote/summernote-bs4.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../../stp_con/fontawesome-free/css/all.min.css">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="../../stp_con/overlayScrollbars/css/OverlayScrollbars.min.css"> 
  <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <link type="text/css" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/south-street/jquery-ui.css" rel="stylesheet"> 
    <script type="text/javascript" src="../../assets/js/jquery.signature.min.js"></script>
    <link rel="stylesheet" type="text/css" href="../../assets/css/jquery.signature.css"> 
</head>
<body class="hold-transition sidebar-mini layout-fixed top-nav  pace-primary">
 
 
 
<div class="container-fluid px-4">
  <h1 class="mt-4">Exam Management</h1>
  <ol class="breadcrumb mb-4" style="background: linear-gradient(#d8d7e8,#f8fcf7,#d8d7e8);" >
        <li class="breadcrumb-item"><a href="../admin.php?page=dashboad">Dashboard</a></li>
        <li class="breadcrumb-item active">Exam List</li>
    </ol>
    
    <span id="message"></span>
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <div class="row">
                <div class="col">
                    <h6 class="m-0 font-weight-bold">Exam List</h6>
                </div>
                <div class="col" align="right">
                    <button type="button" name="add_exam" id="add_exam" class="btn btn-success btn-circle btn-sm"><i class="fas fa-plus"></i></button>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                  <table id="exam_table"  class="table table-striped display table-bordered" >
                    <thead>
                        <tr>
                            <th>Exam Name</th>
                            <th>Class Name</th>
                            <th>Exam Duration</th>
                            <th>Result Date & Time</th>
                            <th>Status</th>
                            <th>Created On</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- <?php
// include('footer.php');
?> -->

<div id="examModal" class="modal fade">
    <div class="modal-dialog">
      <form method="post" id="exam_form">
          <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="modal_title">Add Exam Data</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <span id="form_message"></span>
                    <div class="mb-3">
                        <label>Exam Name</label>
                        <input type="text" name="exam_title" id="exam_title" class="form-control" required data-parsley-pattern="/^[a-zA-Z0-9 \s]+$/" data-parsley-trigger="keyup" />
                    </div>
                    <div class="mb-3">
                        <label>Class</label>
                        <select name="exam_class_id" id="exam_class_id" class="form-control" required>
                            <option value="">Select Class</option>
                            <?php
                            foreach($result as $row)
                            {
                                echo '
                                <option value="'.$row["class_id"].'">'.$row["class_name"].'</option>
                                ';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>Exam Duration for Each Subject <span class="text-danger">*</span></label>
                        <select name="exam_duration" id="exam_duration" class="form-control" required>
                            <option value="">Select</option>
                            <option value="5">5 Minute</option>
                            <option value="30">30 Minute</option>
                            <option value="60">1 Hour</option>
                            <option value="120">2 Hour</option>
                            <option value="180">3 Hour</option>
                        </select>
                    </div>
                    <div class="form-group" id="ifedit">

                    </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" name="hidden_id" id="hidden_id" />
                <input type="hidden" name="action" id="action" value="Add" />
                <input type="submit" name="submit" id="submit_button" class="btn btn-success" value="Add" />
                <button type="button" class="btn btn-default" data-bs-dismiss="modal" aria-label="Close">Close</button>
            </div>
          </div>
      </form>
    </div>
</div>

<div id="publishresultModal" class="modal fade">
    <div class="modal-dialog">
        <form method="post" id="publish_result_form">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal_title">Publish Exam Result</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">                    
                    <div class="mb-3">
                        <label>Exam Result Publish Date & Time</label>
                        <input type="datetime-local" name="exam_result_publish_datetime" id="exam_result_publish_datetime" class="form-control" required data-parsley-trigger="keyup" />
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="hidden" name="hidden_exam_id" id="hidden_exam_id" />
                    <input type="hidden" name="action" id="action" value="Result Publish" />
                    <input type="submit" name="submit" id="result_publish_submit_button" class="btn btn-success" value="Publish" />
                    <button type="button" class="btn btn-default" data-bs-dismiss="modal" aria-label="Close">Close</button>
                </div>
            </div>
        </form>
    </div>
</div>
        <script src="../../vendor/jquery/jquery-3.6.0.min.js"></script>
        <script src="../../vendor/bootstrap/bootstrap.bundle.min.js"></script>
        <script src="../../js/scripts.js"></script>
        <script src="../../vendor/parsley/dist/parsley.min.js"></script>
        <script src="../../vendor/datatables/jquery.dataTables.min.js"></script>
        <script src="../../vendor/datatables/dataTables.bootstrap5.min.js"></script>
 
<script>
$(document).ready(function(){

  var dataTable = $('#exam_table').DataTable({
    "processing" : true,
    "serverSide" : true,
    "order" : [],
    "ajax" : {
      url:"exam_action.php",
      type:"POST",
      data:{action:'fetch'}
    },
    "columnDefs":[
      {
        "targets":[5],
        "orderable":true,
      },
    ],
  });

    /*var date = new Date();
    date.setDate(date.getDate());
    $("#exam_datetime").datetimepicker({
        startDate: date,
        format: 'yyyy-mm-dd hh:ii',
        autoclose: true
    });

    $('#exam_result_publish_datetime').datetimepicker({
        startDate: date,
        format: 'yyyy-mm-dd hh:ii',
        autoclose: true
    });*/

  $('#add_exam').click(function(){
    
    $('#exam_form')[0].reset();

    $('#exam_form').parsley().reset();

      $('#modal_title').text('Add Exam Data');

      $('#action').val('Add');

      $('#submit_button').val('Add');

      $('#examModal').modal('show');

      $('#form_message').html('');

        $('#ifedit').html('');

        $('#exam_class_id').attr('disabled', false);

  });

  $('#exam_form').parsley();

  $('#exam_form').on('submit', function(event){
    event.preventDefault();
    if($('#examModal').parsley().isValid())
    {   
      $.ajax({
        url:"exam_action.php",
        method:"POST",
        data:$(this).serialize(),
        dataType:'json',
        beforeSend:function()
        {
          $('#submit_button').attr('disabled', 'disabled');
          $('#submit_button').val('wait...');
        },
        success:function(data)
        {
          $('#submit_button').attr('disabled', false);
          if(data.error != '')
          {
            $('#form_message').html(data.error);
            $('#submit_button').val('Add');
          }
          else
          {
            $('#examModal').modal('hide');
            $('#message').html(data.success);
            dataTable.ajax.reload();

            setTimeout(function(){

                    $('#message').html('');

                }, 5000);
          }
        }
      })
    }
  });

  $(document).on('click', '.edit_button', function(){

    var exam_id = $(this).data('id');

    $('#exam_form').parsley().reset();

    $('#form_message').html('');

    $.ajax({

          url:"exam_action.php",

          method:"POST",

          data:{exam_id:exam_id, action:'fetch_single'},

          dataType:'JSON',

          success:function(data)
          {

            $('#exam_class_id').val(data.exam_class_id);

                $('#exam_class_id').attr('disabled', 'disabled');

                $('#exam_title').val(data.exam_title);

                $('#exam_duration').val(data.exam_duration);

            $('#modal_title').text('Edit Exam Data');

            $('#action').val('Edit');

            $('#submit_button').val('Edit');

            $('#examModal').modal('show');

            $('#hidden_id').val(exam_id);

                var exam_status_html = '<label>Exam Status <span class="text-danger">*</span></label>';

                exam_status_html += '<select name="exam_status" id="exam_status" class="form-control">';

                exam_status_html += '<option value="Pending">Pending</option>';

                exam_status_html += '<option value="Created">Created</option></select><span class="text-muted"><small>If you have select Created status, then Student will able to view Exam details in their dashboard & you will not able to edit or delete this exam data.</small></span>';

                $('#ifedit').html(exam_status_html);

                $('#exam_status').val(data.exam_status);

          }

      })

  });

  $(document).on('click', '.delete_button', function(){

      var id = $(this).data('id');

      if(confirm("Are you sure you want to remove it?"))
      {

          $.ajax({

            url:"exam_action.php",

            method:"POST",

            data:{id:id, action:'delete'},

            success:function(data)
            {

                $('#message').html(data);

                dataTable.ajax.reload();

                setTimeout(function(){

                  $('#message').html('');

                }, 5000);

            }

          })

      }

    });

    $(document).on('click', '.publish_result', function(){
        var exam_id = $(this).data('exam_id');
        $.ajax({
            url:"exam_action.php",
            method:"POST",
            data:{exam_id:exam_id, action:"fetch_result_publish_data"},
            success:function(data)
            {
                if(data != '')
                {
                    $('#exam_result_publish_datetime').val(data);
                }
                $('#publishresultModal').modal('show');
                $('#hidden_exam_id').val(exam_id);
            }
        });
    });

    $('#publish_result_form').parsley();

    $('#publish_result_form').on('submit', function(event){
        event.preventDefault();
        if($('#publish_result_form').parsley().isValid())
        {       
            $.ajax({
                url:"exam_action.php",
                method:"POST",
                data:$(this).serialize(),
                dataType:'json',
                beforeSend:function()
                {
                    $('#result_publish_submit_button').attr('disabled', 'disabled');
                    $('#result_publish_submit_button').val('wait...');
                },
                success:function(data)
                {
                    $('#result_publish_submit_button').attr('disabled', false);
                    
                    $('#publishresultModal').modal('hide');
                    $('#message').html(data.success);
                    dataTable.ajax.reload();

                    setTimeout(function(){
                        $('#message').html('');
                    }, 5000);
                }
            })
        }
    });

});
</script>