<?php
  // Page title and general setup
  $pageTitle = "Kali Linux Setup and Tools Installation";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, rgba(0,0,0,0.7), rgba(0,0,255,0.5)); /* Fade black and blue */
            color: #fff;
            margin: 0;
            padding: 0;
        }

        header {
            background-color: #00c851; /* Green color */
            padding: 20px;
            text-align: center;
        }

        header h1 {
            font-size: 2.5rem;
            margin: 0;
        }

        section {
            padding: 20px;
            background-color: rgba(0, 0, 0, 0.5);
            margin: 20px;
            border-radius: 8px;
        }

        h2 {
            color: #00c851; /* Green heading */
            font-size: 2rem;
        }

        p {
            font-size: 1rem;
            line-height: 1.6;
        }

        a {
            color: #00c851; /* Green link */
            text-decoration: none;
        }

        a:hover {
            text-decoration: underline;
        }

        footer {
            background-color: #00c851; /* Green footer */
            padding: 10px;
            text-align: center;
        }

        footer p {
            margin: 0;
        }
    </style>
</head>
<body>

<header>
    <h1>Kali Linux Setup and Tools Installation</h1>
</header>

<section>
    <h2>Introduction to Kali Linux</h2>
    <p>Kali Linux is a Debian-based distribution used for penetration testing, ethical hacking, and cybersecurity tasks. In this guide, we will walk you through setting up Kali Linux, installing essential cybersecurity tools, and provide resources to help you get started.</p>
    <p>For detailed basics on Kali Linux, check out the official resources: <a href="https://www.kali.org/docs/">Kali Linux Documentation</a>.</p>
</section>

<section>
    <h2>How to Set Up Kali Linux</h2>
    <p>Follow these steps to install Kali Linux on your system:</p>
    <ul>
        <li>1. Download Kali Linux from the official website: <a href="https://www.kali.org/downloads/">Kali Linux Downloads</a></li>
        <li>2. Create a bootable USB drive or install Kali in a virtual machine (VMware, VirtualBox).</li>
        <li>3. Boot from the USB or start the VM and follow the installation instructions.</li>
        <li>4. Set up your system preferences, user credentials, and network settings.</li>
    </ul>
</section>

<section>
    <h2>Install Cybersecurity Tools</h2>
    <p>Kali Linux comes with many pre-installed cybersecurity tools, but here are a few you can install manually:</p>
    <ul>
        <li><strong>Metasploit Framework:</strong> A popular exploitation framework. To install: <code>sudo apt-get install metasploit-framework</code></li>
        <li><strong>Wireshark:</strong> Network protocol analyzer. To install: <code>sudo apt-get install wireshark</code></li>
        <li><strong>Burp Suite:</strong> A web vulnerability scanner. To install: <code>sudo apt-get install burpsuite</code></li>
        <li><strong>Nmap:</strong> A network scanner. To install: <code>sudo apt-get install nmap</code></li>
        <li><strong>Aircrack-ng:</strong> A tool for Wi-Fi network security testing. To install: <code>sudo apt-get install aircrack-ng</code></li>
    </ul>
</section>

<section>
    <h2>Alternative to Kali Linux</h2>
    <p>If you want to try alternatives to Kali Linux, here are some other popular options for penetration testing:</p>
    <ul>
        <li><strong>Parrot Security OS:</strong> A Debian-based OS focused on security and privacy. <a href="https://www.parrotsec.org/">Learn more</a></li>
        <li><strong>BackBox Linux:</strong> A Ubuntu-based OS with a focus on performance and usability for ethical hacking. <a href="https://www.backbox.org/">Learn more</a></li>
        <li><strong>BlackArch:</strong> An Arch Linux-based distribution for penetration testers. <a href="https://blackarch.org/">Learn more</a></li>
    </ul>
</section>

<footer>
    <p>© 2025 Your Website - All Rights Reserved</p>
</footer>

</body>
</html>
