<?php
require '../admin/includes/connection.php'; // Contains $conn and ZP_API_KEY and ZP_BASE_URL
require 'config.php'; 

$orderId = '68ebdd469ead29.83898526';

$url = ZP_BASE_URL . '/order-status?order_id=' . urlencode($orderId);

$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER     => [
        'x-api-key: ' . ZP_API_KEY,
    ],
]);

$response = curl_exec($ch);
if ($response === false) {
    exit('cURL Error: ' . curl_error($ch));
}

$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
if ($httpCode !== 200) {
    exit("HTTP {$httpCode}: {$response}");
}

$data = json_decode($response, true);
if (!empty($data['data']) && $data['result'] === 'SUCCESS') {
    foreach ($data['data'] as $order) {
        echo "🔎 Order ID: {$order['order_id']}\n";
        echo "   Status: {$order['payment_status']}\n";
        echo "   Amount: {$order['amount']} TZS\n";
        echo "   Reference: {$order['reference']}\n";
    }
} else {
    echo "❌ Error: {$data['message']}\n";
}



// check_status.php

// require 'config.php';
 
// // Accept order_id via GET or POST or JSON
// $input = file_get_contents('php://input');
// $data = json_decode($input, true);
// if (!$data) {
//     // maybe via POST form
//     $data = $_POST;
// }

// if (empty($data['order_id'])) {
//     http_response_code(400);
//     echo json_encode(['error'=>'Missing order_id']);
//     exit;
// }

// $zp_order_id = $data['order_id'];

// // Prepare for ZenoPay status-check request
// $payload = [
//     'check_status' => 1,
//     'order_id'     => $zp_order_id,
//     'api_key'      => ZP_API_KEY,
//     'secret_key'   => ZP_SECRET_KEY
// ];

// $ch = curl_init(ZP_ORDER_STATUS_URL);
// curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
// curl_setopt($ch, CURLOPT_POST, true);
// curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));
// curl_setopt($ch, CURLOPT_HTTPHEADER, [
//     'Content-Type: application/x-www-form-urlencoded'
// ]);

// $response = curl_exec($ch);
// $err = curl_error($ch);
// $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
// curl_close($ch);

// if ($err) {
//     error_log("cURL error in check_status: $err");
//     http_response_code(500);
//     echo json_encode(['error'=>'Request error: '.$err]);
//     exit;
// }

// $response_data = json_decode($response, true);
// if (!$response_data) {
//     error_log("Invalid JSON in check_status response: $response");
//     http_response_code(500);
//     echo json_encode(['error'=>'Invalid response from payment gateway']);
//     exit;
// }

// // Example: ZenoPay might return fields like "payment_status", or "status"
// $payment_status = $response_data['payment_status'] ?? $response_data['status'] ?? null;

// if (!$payment_status) {
//     // Could not find payment status field
//     echo json_encode([
//         'success' => false,
//         'message' => 'Could not retrieve payment status',
//         'response' => $response_data
//     ]);
//     exit;
// }

// // Optionally update DB
// try {
//     $pdo = getPDO();
//     $stmt = $pdo->prepare("
//         UPDATE invoice
//         SET payment_status = :payment_status,
//             updated_at = NOW()
//         WHERE order_id = :order_id
//     ");
//     $stmt->execute([
//         ':payment_status' => $payment_status,
//         ':order_id'       => $zp_order_id
//     ]);

//     echo json_encode([
//         'success' => true,
//         'order_id' => $zp_order_id,
//         'payment_status' => $payment_status,
//         'message' => 'Status updated locally'
//     ]);
// } catch (PDOException $e) {
//     http_response_code(500);
//     echo json_encode(['error'=>'Database error: '.$e->getMessage()]);
// }
